package com.patzn.lims.sys.service.impl;

import com.patzn.lims.sys.entity.SysMessage;
import com.patzn.lims.sys.entity.SysUserRelMessage;
import com.patzn.lims.sys.mapper.SysUserRelMessageMapper;
//import com.patzn.lims.sys.service.ISysMessageService;
import com.patzn.lims.sys.service.ISysUserRelMessageService;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

import static java.util.stream.Collectors.toList;

/**
 * <p>
 * 用户消息关联表 服务实现类
 * </p>
 *
 * @author wwd
 * @since 2020-03-18
 */
@Service
public class SysUserRelMessageServiceImpl extends BaseServiceImpl<SysUserRelMessageMapper, SysUserRelMessage> implements ISysUserRelMessageService {

//    @Autowired
//    private ISysMessageService sysMessageService;

    @Override
    public Page<SysUserRelMessage> page(Page<SysUserRelMessage> page, SysUserRelMessage sysUserRelMessage) {
        QueryWrapper<SysUserRelMessage> wrapper = Wrappers.<SysUserRelMessage>query(sysUserRelMessage);
        return this.page(page, wrapper);
    }

    @Override
    public List<Map<String, Object>> selectTypeCountMapList(Long currentUserId) {
        return baseMapper.selectTypeCountMapList(currentUserId);
    }

    @Override
    public List<SysMessage> selectMyMessage(Long userId, int type) {
        return baseMapper.selectMyMessage(userId,type);
    }


    @Override
    public List<Long> listPersonsByLabelUri(Long companyId, String uri) {
        List<SysMessage> sysMessageList = baseMapper.selectPersonsByLabelUri(companyId, uri);
        if (CollectionUtils.isEmpty(sysMessageList)) {
            return null;
        }
        return sysMessageList.stream().map(m -> m.getUid()).collect(toList());

    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean save(SysMessage sysMessage, List<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return false;
        }
        SysMessage temp = new SysMessage();
        temp.setId(sysMessage.getId());
        temp.setSend(1);
        List<SysUserRelMessage> relMessageList = userIds.stream().filter(id -> null != id).map(id -> {
            SysUserRelMessage rel = new SysUserRelMessage();
            rel.setMessageId(sysMessage.getId());
            rel.setType(sysMessage.getType());
            rel.setCompanyId(sysMessage.getCompanyId());
            rel.setUserId(id);
            rel.setRead(0);
            return rel;
        }).collect(toList());
        return false;
//        return sysMessageService.updateById(temp) && (CollectionUtils.isEmpty(relMessageList) || super.saveBatch(relMessageList));

    }
}
