package com.patzn.lims.sys.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.sys.entity.SysUserRelModule;
import com.patzn.lims.sys.mapper.SysUserRelModuleMapper;
import com.patzn.lims.sys.service.ISysUserRelModuleService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 用户模块关联表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-10-25
 */
@Service
public class SysUserRelModuleServiceImpl extends BaseServiceImpl<SysUserRelModuleMapper, SysUserRelModule> implements ISysUserRelModuleService {


    @Override
    public IPage<SysUserRelModule> page(Page<SysUserRelModule> page, SysUserRelModule sysUserRelModule) {
        return this.page(page, Wrappers.query(sysUserRelModule));
    }


    @Override
    public List<SysUserRelModule> list(SysUserRelModule sysUserRelModule) {
        return this.list(Wrappers.query(sysUserRelModule));
    }


    @Override
    public boolean remove(Long userId, Long moduleId) {
        return super.remove(Wrappers.<SysUserRelModule>query()
                .eq("user_id", userId)
                .eq("module_id", moduleId));
    }
}
