package com.patzn.lims.sys.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.sys.entity.SysUser;
import com.patzn.lims.sys.entity.SysUserRelOrg;
import com.patzn.lims.sys.mapper.SysUserRelOrgMapper;
import com.patzn.lims.sys.service.ISysUserRelOrgService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 用户组织关联表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-08-03
 */
@Service
public class SysUserRelOrgServiceImpl extends BaseServiceImpl<SysUserRelOrgMapper, SysUserRelOrg> implements ISysUserRelOrgService {

    @Override
    public IPage<SysUserRelOrg> page(Page<SysUserRelOrg> page, SysUserRelOrg sysUserRelOrg) {
        return page(page, Wrappers.query(sysUserRelOrg));
    }

    @Override
    public Page<SysUser> pageByOrgId(Page<SysUser> page, Long orgId, Long companyId, Boolean activation, String realname) {
        if (null == activation) {
            activation = false;
        }
        return page.setRecords(baseMapper.selectPageByOrgId(page, orgId, companyId, activation, realname));
    }


    @Override
    public List<SysUser> listByOrgId(Long orgId, Long companyId, String realname) {
        if (StringUtils.isBlank(realname)){
            return baseMapper.selectListByOrgIdNo(orgId, companyId);
        }else {
            return baseMapper.selectListByOrgId(orgId, companyId,realname);
        }

    }

    @Override
    public List<SysUser> listByCompanyId(Long companyId, String realname) {
        return baseMapper.selectListByCompanyId(companyId, realname);
    }

    @Override
    public List<SysUserRelOrg> getRelOrg(Long userId) {
        return list(Wrappers.<SysUserRelOrg>query()
                .select("org_id").eq("user_id", userId));
    }


    @Override
    public boolean saveRelOrg(Long userId, Long orgId) {
        SysUserRelOrg rel = new SysUserRelOrg();
        rel.setUserId(userId);
        rel.setOrgId(orgId);
        return super.save(rel);
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveRelOrg(Long userId, List<Long> orgIds) {
        int result = baseMapper.delete(Wrappers.<SysUserRelOrg>query().eq("user_id", userId));
        if (CollectionUtils.isNotEmpty(orgIds)) {
            return saveBatch(orgIds.stream().map(orgId -> {
                SysUserRelOrg rel = new SysUserRelOrg();
                rel.setUserId(userId);
                rel.setOrgId(orgId);
                return rel;
            }).collect(Collectors.toList()));
        }
        return SqlHelper.retBool(result);
    }
}
