package com.patzn.lims.sys.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.sys.entity.SysUser;
import com.patzn.lims.sys.entity.SysUserRelRole;
import com.patzn.lims.sys.mapper.SysUserRelRoleMapper;
import com.patzn.lims.sys.service.ISysUserRelRoleService;
import com.patzn.lims.sys.service.ISysUserService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 用户角色关联表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-08-03
 */
@Service
public class SysUserRelRoleServiceImpl extends BaseServiceImpl<SysUserRelRoleMapper, SysUserRelRole> implements ISysUserRelRoleService {

    @Autowired
    private ISysUserService sysUserService;


    @Override
    public IPage<SysUserRelRole> page(Page<SysUserRelRole> page, SysUserRelRole sysUserRelRole) {
        return page(page, Wrappers.query(sysUserRelRole));
    }


    @Override
    public List<SysUserRelRole> list(SysUserRelRole sysUserRelRole) {
        return list(Wrappers.query(sysUserRelRole));
    }


    @Override
    public List<SysUserRelRole> getRelRole(Long userId) {
        return list(Wrappers.<SysUserRelRole>query().select("role_id")
                .eq("user_id", userId));
    }

    @Override
    public boolean saveRelRole(Long companyId, Long userId, Long roleId) {
        SysUserRelRole rel = new SysUserRelRole();
        rel.setUserId(userId);
        rel.setCompanyId(companyId);
        rel.setRoleId(roleId);
        return super.save(rel);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveRelRole(Long userId, List<Long> roleIds) {
        if (null == userId || CollectionUtils.isEmpty(roleIds)) {
            return false;
        }
        SysUser sysUser = sysUserService.getById(userId);
        if (1 == sysUser.getAdmin() && !LoginHelper.isSysAdmin()) {
            PtAssert.fail("抱歉！您无权修改管理员角色信息。");
        }
        baseMapper.delete(Wrappers.<SysUserRelRole>query().eq("user_id", userId));
        List<SysUserRelRole> relList = roleIds.stream().map(roleId -> {
            SysUserRelRole rel = new SysUserRelRole();
            rel.setUserId(userId);
            rel.setRoleId(roleId);
            rel.setCompanyId(sysUser.getCompanyId());
            return rel;
        }).collect(Collectors.toList());
        return saveBatch(relList);
    }


    @Override
    public Long getFirstRelRoleId(Long companyId, Long userId) {
        SysUserRelRole rel = super.getOne(Wrappers.<SysUserRelRole>query()
                .select("role_id").eq("user_id", userId)
                .eq("company_id", companyId).last("LIMIT 1"));
        return null != rel ? rel.getRoleId() : null;
    }
}
