package com.patzn.lims.sys.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.sys.entity.SysWxmpUser;
import com.patzn.lims.sys.mapper.SysWxmpUserMapper;
import com.patzn.lims.sys.service.ISysWxmpUserService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 微信公众号用户表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-03-12
 */
@Service
public class SysWxmpUserServiceImpl extends BaseServiceImpl<SysWxmpUserMapper, SysWxmpUser> implements ISysWxmpUserService {

    @Override
    public boolean updateByUnionId(Long userId, String unionId) {
        if (null == unionId || StringUtils.isEmpty(unionId)) {
            return false;
        }
        return update(new SysWxmpUser().setUserId(userId), Wrappers.<SysWxmpUser>query()
                .eq("unionid", unionId));
    }
}
