package com.patzn.lims.sys.vo;

import com.patzn.lims.sys.entity.SysMessage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 消息 LIST VO
 * </p>
 *
 * @author hubin
 * @since 2018-01-03
 */
@Data
@Accessors(chain = true)
@ApiModel
public class SysMessageListVO implements Serializable {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "总数量")
  private Integer sum;

  @ApiModelProperty(value = "列表")
  private List<SysMessage> list;

  public SysMessageListVO() {

  }

  public SysMessageListVO(Integer sum, List<SysMessage> list) {
    this.sum = sum;
    this.list = list;
  }
}
