package com.patzn.lims.workflow;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <p>
 * Flowable 流程定义解析表
 * </p>
 *
 * @author patzn
 * @since 2017-09-05
 */
@Data
@Accessors(chain = true)
@ApiModel
@TableName("act_re_procdef")
public class ActReProcdef implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId("id_")
    @ApiModelProperty(value = "主键")
    protected String id;

    @TableField("name_")
    @ApiModelProperty(value = "名称")
    private String name;

    @TableField("version_")
    @ApiModelProperty(value = "版本")
    private String version;

    @TableField("deployment_id_")
    @ApiModelProperty(value = "部署 ID")
    private String deploymentId;

    @TableField("key_")
    @ApiModelProperty(value = "流程 Key")
    private String key;

    @TableField("description_")
    @ApiModelProperty(value = "描述")
    private String description;

    @TableField("has_start_form_key_")
    @ApiModelProperty(value = "是否从 Key 启动")
    private Boolean haskey;

    @TableField("suspension_state_")
    @ApiModelProperty(value = "1、激活 2、挂起")
    private Integer state;

    @TableField("tenant_id_")
    @ApiModelProperty(value = "1、激活 2、挂起")
    private String tenant;

}
