package com.patzn.lims.workflow;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 工作流组表
 * </p>
 *
 * @author patzn
 * @since 2017-10-25
 */
@Data
@Accessors(chain = true)
@ApiModel
public class FlowGroup extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "父 ID")
	private Long pid;

    @ApiModelProperty(value = "企业 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "组名")
	private String name;

    @ApiModelProperty(value = "工作流别名")
	private String alias;

    @ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;


}
