package com.patzn.lims.workflow;

import com.patzn.lims.core.web.Account;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;

/**
 * <p>
 * 工作流任务
 * </P>
 *
 * @author hubin
 * @since 2017-09-27
 */
@Data
@Accessors(chain = true)
@ApiModel
public class FlowInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 静态常量
     */
    public static final String FLOW_INFO = "flowInfo";
    public static final String FLOW_NAME = "flowName";
    public static final String APPLY_ID = "applyId";

    @ApiModelProperty(value = "工作流类型")
    private String flowType;

    @ApiModelProperty(value = "工作流名称")
    private String flowName;

    @ApiModelProperty(value = "业务 ID")
    private Long id;

    @ApiModelProperty(value = "申请者 ID")
    private String applyId;

    @ApiModelProperty(value = "申请者名称")
    private String applyName;

    @ApiModelProperty(value = "申请时间")
    private Date applyTime;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "参数", dataType = "java.utils.Map")
    private Map<String, Object> variables;


    /**
     * 工作流逻辑 KEY
     *
     * @return id 的字符串
     */
    public String getBusinessKey() {
        return id == null ? null : String.valueOf(id);
    }

    /**
     * 流程中文名称
     *
     * @return 中文名称
     */
    public String getFlowName() {
        if (null == this.flowName) {
            return "/";
        }
        return this.flowName;
    }

    /**
     * <p>
     * 工作流对象转换
     * </p>
     *
     * @param flowType 流程类型
     * @param account  账号信息
     * @param id       业务 ID
     * @param remark   备注
     * @return 流程对象
     */
    public static FlowInfo convertFlowInfo(FlowType flowType, Account account, Long id, String remark) {
        FlowInfo flowInfo = new FlowInfo();
        flowInfo.setFlowType(flowType.getValue());
        flowInfo.setFlowName(flowType.getDisplay());
        flowInfo.setId(id);
        flowInfo.setApplyId(account.getUserIdStr());
        flowInfo.setApplyName(account.getUserName());
        flowInfo.setRemark(remark);
        flowInfo.setApplyTime(new Date());
        return flowInfo;
    }

    public String getFlowType() {
        return flowType;
    }

    public void setFlowType(String flowType) {
        this.flowType = flowType;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getApplyId() {
        return applyId;
    }

    public void setApplyId(String applyId) {
        this.applyId = applyId;
    }

    public String getApplyName() {
        return applyName;
    }

    public void setApplyName(String applyName) {
        this.applyName = applyName;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
