package com.patzn.lims.workflow;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;

/**
 * <p>
 * 工作流执行任务
 * </P>
 *
 * @author hubin
 * @since 2017-09-27
 */
@Data
@Accessors(chain = true)
public class FlowTask implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "任务 ID")
    String id;
    @ApiModelProperty(value = "任务名称")
    String name;
    @ApiModelProperty(value = "描述")
    String description;
    @ApiModelProperty(value = "优先权")
    int priority;
    @ApiModelProperty(value = "拥有者")
    String owner;
    @ApiModelProperty(value = "代理人")
    String assignee;
    @ApiModelProperty(value = "授权状态")
    String delegationState;
    @ApiModelProperty(value = "到期时间")
    Date dueDate;
    @ApiModelProperty(value = "分类")
    String category;
    @ApiModelProperty(value = "父任务 ID")
    String parentTaskId;
    @ApiModelProperty(value = "租户 ID")
    String tenantId;
    @ApiModelProperty(value = "form key")
    String formKey;
    @ApiModelProperty(value = "停止状态")
    boolean suspended;
    @ApiModelProperty(value = "执行实例 ID")
    String processInstanceId;
    @ApiModelProperty(value = "执行 ID")
    String executionId;
    @ApiModelProperty(value = "执行定义 ID")
    String processDefinitionId;
    @ApiModelProperty(value = "创建时间")
    Date createTime;
    @ApiModelProperty(value = "任务定义 KEY")
    String taskDefinitionKey;
    @ApiModelProperty(value = "任务参数")
    Map<String, Object> taskLocalVariables;
    @ApiModelProperty(value = "执行参数")
    Map<String, Object> processVariables;
    @ApiModelProperty(value = "要求时间")
    Date claimTime;

}
