package com.patzn.lims.workflow;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.IBaseEnum;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

/**
 * <p>
 * 工作流执行任务类型
 * </p>
 *
 * @author hubin
 * @since 2017-08-19
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum FlowType implements IBaseEnum {
    /**
     * 耗材采购流程
     */
    CHEMICAL_PURCHASE_ORDER("chemicalPurchaseOrder", "耗材采购流程"),
    /**
     * 耗材出库流程
     */
    CHEMICAL_DELIVERY("chemicalDelivery", "耗材出库流程"),
    /**
     * 仪器采购流程
     */
    EQUIP_PURCHASE_ORDER("equipPurchaseOrder", "仪器采购流程"),
    //add
    /**
     * 仪器出库流程
     */
    EQUIP_DELIVERY("equipDelivery", "仪器出库流程"),
    /**
     * 仪器预约流程
     */
    EQUIP_ORDER("equipOrder", "仪器预约流程"),
    /**
     * 仪器维保流程
     */
    EQUIP_MAINTAIN("equipMaintain", "仪器维保流程"),
    /**
     * 仪器维修流程
     */
    EQUIP_REPAIR("equipRepair", "仪器维修流程"),
    /**
     * 仪器报废流程
     */
    EQUIP_SCRAP("equipScrap", "仪器报废流程"),
    /**
     * 仪器期间核查流程
     */
    EQUIP_CHECK("equipCheck", "仪器期间核查流程"),

    /**
     * 年度不确定度计划审批流程
     */
    YEAR_UNSURE_CHECK("year_unsure_plan_check", "年度不确定度计划审批流程"),


    ENV_PROJECT_CHECK("envPlanCheck", "环境项目评审"),


    INNER_PLAN_CHECK("innerCheck", "内审计划评审"),


    MANAGE_CHECK("manageCheck", "管理评审计划审批"),


    STAFF_TRAIN_PLAN_CHECK("staffTrainCheck", "人员培训计划评审"),


    QC_PLAN_CHECK("qcPlanCheck", "内部质控计划评审"),


    ABILITY_PLAN_CHECK("abilityPlanCheck", "能力验证计划评审"),


    FRAME_UNCOMFORT_REGISTER("frameUnconform", "不符合项登记流程"),


    ENV_PROJECT_CHECK_SIMPLE("envSimplePlanCheck", "环境简版项目评审"),


    REPORT_BORROW("reportBorrow", "报告借阅评审"),


    REPORT_BORROW_SIMPLE("reportBorrowSimple", "环境简版报告借阅评审"),


    FOOD_SIMPLE_HANDLE_APPLY("foodSampleHandleApply", "食品样品处理申请审批"),


    REPORT_BORROW_FOOD("reportBorrowFood", "食品报告借阅评审"),


    ENV_CONTRACT_REVIEW("envContractReview", "环境委托评审"),


    ENV_SALES_REVIEW("envSalesCheck", "环境合同审批"),

    /**
     * 合同审批一级五人审批
     */
    ENV_SALES_FIVE_REVIEW("envSalesFirstFiveCheck", "环境合同多级审批"),


    ENV_SIMPLE_SALES_REVIEW("envSimpleSalesCheck", "环境简版合同审批"),

    /**
     * 耗材过期处理审批流程
     */
    LMS_CHEMICAL_STOCK_HANDLE("lmsChemicalStockHandle", "耗材过期处理审批流程"),

    PROBLEM_IMPROVE("problemImprove", "改进/纠正/预防措施管理审批"),

    COMPLAINT_REGISTER("complaintRegister", "投/申诉登记审批"),

    /**
     * 标准物质处理审批
     */
    BASIC_PROCESS_CHECK("basicProcessCheck","标准物质处理审批"),

    /**
     * 标准物质采购流程
     */
    SUBSTANCE_PURCHASE_ORDER("substancePurchaseOrder", "标准物质采购流程"),
    /**
     * 标准物质使用审批
     */
    SUBSTANCE_DELIVER_ORDER("substanceDeliverOrder","标准物质使用申请"),

    /**
     * 文件销毁审批流
     */
    FILE_DESTRUCTION("fileDestruction","文件销毁审批流"),

    /**
     * 文件签入审批流
     */
        FILE_CHECK("fileCheck","文件签入审批流"),
    ;


    private final String value;
    private String display;

    FlowType(String value, String display) {
        this.value = value;
        this.display = display;
    }

    public static FlowType fromValue(String value) {
        FlowType[] fts = FlowType.values();
        for (FlowType ft : fts) {
            if (ft.getValue().equals(value)) {
                return ft;
            }
        }
        return null;
    }

    @Override
    public String getValue() {
        return value;
    }

    @Override
    public String getName() {
        return name();
    }

    @Override
    public String getDisplay() {
        return display;
    }
}
