package com.patzn.lims.workflow;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Map;

/**
 * <p>
 * 工作流执行任务参数
 * </P>
 *
 * @author hubin
 * @since 2017-09-27
 */
@Data
@Accessors(chain = true)
@ApiModel
public class FlowVariables implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "流程 ID")
    private String id;
    @ApiModelProperty(value = "任务 ID")
    private String taskId;
    @ApiModelProperty(value = "参数", dataType = "java.utils.Map")
    private Map<String, Object> variables;

    public FlowVariables() {
    }

    public FlowVariables(String taskId) {
        this.taskId = taskId;
    }

}
