package com.patzn.lims.workflow.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.workflow.FlowGroup;
import com.patzn.lims.workflow.service.IFlowGroupService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 工作流组表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-10-25
 */
@Api(tags = "工作流组表")
@RestController
@RequestMapping("/v1/group")
public class FlowGroupController extends SuperController {
    @Autowired
    private IFlowGroupService flowGroupService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<Page<FlowGroup>> getPage(FlowGroup flowGroup) {
        flowGroup.setCompanyId(this.currentCompanyId());
        return success(flowGroupService.page(getPage(), flowGroup));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<FlowGroup>> getList(FlowGroup flowGroup) {
        flowGroup.setCompanyId(this.currentCompanyId());
        return success(flowGroupService.list(flowGroup));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    public PtResult<FlowGroup> get(@PathVariable("id") Long id) {
        return success(flowGroupService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, FlowGroup flowGroup) {
        flowGroup.setCompanyId(this.currentCompanyId());
        return success(flowGroupService.updateById(flowGroup));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(FlowGroup flowGroup) {
        flowGroup.setCompanyId(this.currentCompanyId());
        return success(flowGroupService.save(flowGroup));
    }
}
