package com.patzn.lims.workflow.service;

import com.patzn.lims.core.web.Account;
import com.patzn.lims.workflow.FlowInfo;
import com.patzn.lims.workflow.FlowProcess;
import com.patzn.lims.workflow.FlowVariables;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


public interface IFlowProcessService {

    List<FlowProcess> saveTask(List<FlowInfo> flowTaskList, Account account);

    /**
     * <p>
     * 激活执行流程
     * </p>
     *
     * @param processDefinitionKey 执行定义 Key
     * @param account              登录账号信息
     * @return
     */
    boolean activateProcess(String processDefinitionKey, Account account);

    /**
     * <p>
     * 挂起执行流程
     * </p>
     *
     * @param processDefinitionKey 执行定义 Key
     * @param account              登录账号信息
     * @return
     */
    boolean suspendProcess(String processDefinitionKey, Account account);

    /**
     * <p>
     * 删除执行流程
     * </p>
     *
     * @param deploymentId 部署 ID
     * @param cascade      是否级联操作
     * @return
     */
    boolean deleteDeployment(String deploymentId, boolean cascade);


    boolean deploy(Long companyId, MultipartFile file);


    /**
     * <p>
     * 通知申请人审批结果
     * </p>
     *
     * @param taskId 任务 ID
     * @param remark 备注
     * @return
     */
    FlowInfo notifyApplyer(String taskId, String remark);

    /**
     * <p>
     * 添加工作流管理关系
     * </p>
     *
     * @param groupId 用户组 ID
     * @param userIds 用户 ID
     * @return
     */
    boolean saveFlowMemberShip(String groupId, String[] userIds);

    /**
     * <p>
     * 移除工作流管理关系
     * </p>
     *
     * @param groupId 用户组 ID
     * @param userIds 用户 ID
     * @return
     */
    boolean removeFlowMemberShip(String groupId, String[] userIds);

    /**
     * <p>
     * 流程认领
     * </p>
     *
     * @param taskId 任务 ID
     * @param userId 用户 ID
     * @return
     */
    boolean claimTask(String taskId, String userId);

    /**
     * <p>
     * 流程执行任务认领
     * </p>
     *
     * @param executionIds 执行 ID 列表
     * @param userId       用户 ID
     * @return
     */
    boolean claimTaskByExecutionIds(List<String> executionIds, String userId);


    /**
     * <p>
     * 流程节点表单 KEY
     * </p>
     *
     * @param taskId 任务 ID
     * @return
     */
    String fromKeyByTaskId(String taskId);

    /**
     * <p>
     * 流程节点表单 KEY
     * </p>
     *
     * @param executionId 执行 ID
     * @return
     */
    String fromKeyByExecutionId(String executionId);


    FlowInfo complete(String taskId);


    FlowInfo complete(FlowVariables flowVariables);


    void diagramByTaskId(HttpServletResponse response, String taskId);


    void diagramByExecutionId(HttpServletResponse response, String executionId);
}
