package com.patzn.lims.workflow.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.workflow.FlowGroup;
import com.patzn.lims.workflow.mapper.FlowGroupMapper;
import com.patzn.lims.workflow.service.IFlowGroupService;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.IdentityService;
import org.flowable.idm.api.Group;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 工作流组表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-10-25
 */
@Service
public class FlowGroupServiceImpl extends BaseServiceImpl<FlowGroupMapper, FlowGroup> implements IFlowGroupService {

    @Autowired
    private IdentityService identityService;


    @Override
    public Page<FlowGroup> page(Page<FlowGroup> page, FlowGroup flowGroup) {
        QueryWrapper<FlowGroup> wrapper = Wrappers.query();
        wrapper.eq("company_id", flowGroup.getCompanyId());
        wrapper.like(StringUtils.isNotEmpty(flowGroup.getName()), "name", flowGroup.getName());
        wrapper.like(StringUtils.isNotEmpty(flowGroup.getAlias()), "alias", flowGroup.getAlias());
        return this.page(page, wrapper);
    }


    @Override
    public List<FlowGroup> list(FlowGroup flowGroup) {
        QueryWrapper<FlowGroup> wrapper = Wrappers.query();
        wrapper.select("id", "pid", "name");
        wrapper.eq("company_id", flowGroup.getCompanyId());
        return this.list(wrapper);
    }


    @Override
    public boolean updateById(FlowGroup flowGroup) {
        this.verifyFlowGroup(flowGroup);
        return super.updateById(flowGroup);
    }

    @Override
    public boolean save(FlowGroup flowGroup) {
        this.verifyFlowGroup(flowGroup);
        flowGroup.setId(IdWorker.getId());
        boolean result = super.save(flowGroup);
        if (result) {
            // 保存机构信息至工作流组
            Group group = identityService.newGroup(String.valueOf(flowGroup.getId()));
            group.setName(flowGroup.getName());
            identityService.saveGroup(group);
        }
        return result;
    }


    /**
     * 角色名称校验
     */
    private void verifyFlowGroup(FlowGroup flowGroup) {
        QueryWrapper<FlowGroup> wrapper = Wrappers.query();
        wrapper.eq("company_id", flowGroup.getCompanyId());
        wrapper.and(e -> e.ne("name", flowGroup.getName()).or().eq("alias", flowGroup.getAlias()));
        if (null != flowGroup.getId()) {
            wrapper.ne("id", flowGroup.getId());
        }
        List<FlowGroup> flowGroupList = super.list(wrapper);
        for (FlowGroup entity : flowGroupList) {
            if (null != entity.getName() && entity.getName().equals(flowGroup.getName())) {
                PtAssert.fail("抱歉!该组名已存在，请改换组名。");
            } else if (null != entity.getAlias() && entity.getAlias().equals(flowGroup.getAlias())) {
                PtAssert.fail("抱歉!该别名已存在，请改换别名。");
            }
        }
    }
}
