/**
 * 全局相关配置
 */
import Store from 'store2'
import Qs from 'qs'
// 对外暴露全局常量及函数
export default {
  headers: {
    'Content-Type': 'application/x-www-form-urlencoded'
  },
  headersJson: {
    'Content-Type': 'application/json'
  },
  // 系统标签名称
  tabName: function() {
    return '系统管理'
  },
  // 用户信息
  setUserInfo: function(userInfo) {
    Store.session('userInfo', userInfo)
  },
  getUserInfo: function() {
    return Store.session('userInfo')
  },
  getLn: function() {
    return this.getCookie('ln')
  }, // 缓存导航和按钮权限信息等
  setCommonInfo: function(msg, data) {
    Store.session(msg, data)
  },
  // 获取导航和按钮权限信息等
  getCommonInfo: function(data) {
    const str = Store.session(data)
    return str || ''
  },
  // 获取tooken
  getToken: function() {
    return localStorage.getItem('accessToken')
  },
  // // 多语言
  // setLang: function(data) {
  //   localStorage.setItem('lang', data)
  // },
  // getLang: function() {
  //   const lang = localStorage.getItem('lang')
  //     ? localStorage.getItem('lang')
  //     : 'cn'
  //   return lang
  // },
  // code
  getCode: function() {
    return 'sys'
  },
  getCookie: function(cookieName) {
    if (document.cookie.length > 0) {
      let start = document.cookie.indexOf(cookieName + '=')
      if (start !== -1) {
        start = start + cookieName.length + 1
        let end = document.cookie.indexOf(';', start)
        if (end === -1) end = document.cookie.length
        return document.cookie.substring(start, end)
      }
    }
    return null
  },
  logout: function() {
    // 清空所有缓存数据，保留主题选择、用户名、密码
    const themeFile = Store.get('themeFile')
    const username = Store.get('username')
    const password = Store.get('password')
    // 退出后清空按钮权限、菜单、个人信息
    Store.session('showBtnList', '')
    Store.session('nav', '')
    Store.session('userInfo', '')
    Store.session('isLock', '')
    // Store.clearAll()
    if (themeFile) {
      localStorage.setItem('themeFile', themeFile)
    }
    Store.set('username', username)
    Store.set('password', password)
  },
  env: process.env.NODE_ENV,
  baseURL: process.env.BASE_URL,
  ssoURL: process.env.SSO_URL,
  webURL: process.env.WEB_URL,
  // 静态服务地址
  staticURL: process.env.STATIC_URL,
  transformRequest: [
    // 后面数组中的函数必须返回一个字符串，或 ArrayBuffer，或 Stream
    function(data) {
      return Qs.stringify(data)
    }
  ],
  // 参数为json
  transformRequestJSON: [
    function(data) {
      return JSON.stringify(data)
    }
  ]
}
