import http from '../http'

export default {
  page: data => http.post('/v1/chemical_classify/page', data).then(res => res),
  getById: id => http.get('/v1/chemical_classify/' + id).then(res => res),
  edit: data =>
    http.put('/v1/chemical_classify?id=' + data.id, data.obj).then(res => res),
  add: data => http.post('/v1/chemical_classify/', data).then(res => res),
  saveClassifyConsume: data =>
    http
      .post(
        '/v1/chemical_classify/rel_chemical_' +
          data.classifyId +
          '?chemicalIds=' +
          data.chemicalIds
      )
      .then(res => res),
  removeClassifyConsume: data =>
    http
      .delete(
        '/v1/chemical_classify/rel_chemical_' +
          data.classifyId +
          '?chemicalIds=' +
          data.chemicalIds
      )
      .then(res => res)
}
