import http from '../http'

export default {
  page: data =>
    http.post('/v1/chemical_delivery_order/page', data).then(res => res),
  pageTemp: data =>
    http.post('/v1/chemical_delivery_order/page_temp', data).then(res => res),
  pageWaitDelivery: data =>
    http
      .post('/v1/chemical_delivery_order/page_wait_delivery', data)
      .then(res => res),
  getById: id => http.get('/v1/chemical_delivery_order/' + id).then(res => res),
  edit: data =>
    http
      .put('/v1/chemical_delivery_order?id=' + data.id, data.obj)
      .then(res => res),
  add: data =>
    http
      .post('/v1/chemical_delivery_order/' + data.approve, data)
      .then(res => res),
  flowSubmit: data =>
    http
      .post('/v1/chemical_delivery_order/flow_submit?ids=' + data)
      .then(res => res),
  approve: data =>
    http
      .post('/v1/chemical_delivery_order/flow_approve/' + data.id, data)
      .then(res => res)
}
