import http from '../http'
export default {
  page: data =>
    http.post('/v1/equip_delivery_order/allpage', data).then(res => res),
  pageWaitOut: data =>
    http.post('/v1/equip_delivery_order/page_wait_out', data).then(res => res),
  flowSubmit: data =>
    http.post('/v1/equip_delivery_order/submit/' + data).then(res => res),
  getById: id => http.get('/v1/equip_delivery_order/' + id).then(res => res),
  list: data =>
    http.post('/v1/equip_delivery_order/list', data).then(res => res),
  edit: data =>
    http
      .put('/v1/equip_delivery_order?id=' + data.id, data.obj)
      .then(res => res),
  add: data => http.post('/v1/equip_delivery_order/', data).then(res => res),
  outStock: data =>
    http
      .post('/v1/equip_delivery_order/outstock/' + data.orderId, data)
      .then(res => res),
  purOrder: data =>
    http
      .post('/v1/equip_delivery_order/' + data.approve, { reason: data.reason })
      .then(res => res),
  approveEquip: data =>
    http
      .post('/v1/equip_delivery_order/approve/' + data.id, data)
      .then(res => res)
}
