import http from '../http'

export default {
  page: data => http.post('/v1/staff_train_plan/page', data).then(res => res),
  getTemp: data =>
    http.post('/v1/staff_train_plan/temp', data).then(res => res),
  getById: id => http.get('/v1/staff_train_plan/' + id).then(res => res),
  deleteById: id => http.delete('/v1/staff_train_plan/' + id).then(res => res),
  list: data => http.post('/v1/staff_train_plan/list', data).then(res => res),
  edit: data =>
    http.put('/v1/staff_train_plan?id=' + data.id, data.obj).then(res => res),
  add: data => http.post('/v1/staff_train_plan/', data).then(res => res),
  commit: data =>
    http.post('/v1/staff_train_plan/commit', data).then(res => res),
  approve: data =>
    http
      .post('/v1/staff_train_plan/approve/' + data.taskId, data)
      .then(res => res),
  submitById: data =>
    http.post('/v1/staff_train_plan/submit_flow/?ids=' + data).then(res => res)
}
