/**
 * 系统表格
 */

import http from '../http'
import httpJson from '../httpJson'

export default {
  // 根据表格名称查询企业下的表格列
  getByCompanyTable: data =>
    http.post('/v1/table_column/list_company_code_' + data).then(res => res),
  // 当前用户指定表格字段
  getByUserTable: data =>
    http.post('/v1/table_column/list_user_' + data).then(res => res),
  page: data => http.post('/v1/table_column/page', data).then(res => res),
  add: data => http.post('/v1/table_column/', data).then(res => res),
  edit: data =>
    http.put('/v1/table_column/' + data.id, data.obj).then(res => res),
  getById: data => http.get('/v1/table_column/' + data).then(res => res),
  deleteById: data =>
    http.delete('/v1/table_column/?ids=' + data).then(res => res),
  // 表格权限树
  getListTree: data =>
    http.post('/v1/table_column/list_tree_' + data).then(res => res),
  getByCompanyId: id =>
    http.post('/v1/table_column/list_company_' + id).then(res => res),
  companySave: data =>
    httpJson.post('/v1/table_column/company', data).then(res => res),
  // 当前企业的表格权限tree
  currentCompanyTree: data =>
    http.post('/v1/table_column/list_tree_current_company').then(res => res),
  // 查询当前企业表字段列表(已选中的)
  getByCurrentCompanyId: data =>
    http.post('/v1/table_column/list_current_company').then(res => res)
}
