/**
 * 执行工作流相关
 */
import http from '../http'

const url = '/v1/flow-process/'

export default {
  page: data => http.post(url + 'page', data).then(res => res),
  pageTask: data => http.post(url + 'page-task', data).then(res => res),
  totalTask: () => http.post(url + 'total-task').then(res => res),
  claimTask: data => http.post(url + 'claim-task/' + data).then(res => res),
  addMemberShip: data =>
    http
      .post(url + 'member-ship/' + data.groupId + '?userIds=' + data.userIds)
      .then(res => res),
  deleteMemberShip: data =>
    http
      .delete(url + 'member-ship/' + data.groupId + '?userIds=' + data.userIds)
      .then(res => res),
  activateProcess: data =>
    http.post(url + 'activate-process/' + data).then(res => res),
  suspendProcess: data =>
    http.post(url + 'suspend-process/' + data).then(res => res),
  dropProcess: data => http.post(url + 'drop-process/' + data).then(res => res),
  fromKeyByTid: data => http.post(url + 'from-key-tid-' + data).then(res => res)
}
