import http from '../http'
export default {
  pageMaintain: data =>
    http.post('/v1/equip_maintain/page_maintain', data).then(res => res),
  getById: id => http.get('/v1/equip_maintain/vo/' + id).then(res => res),
  getVOById: data =>
    http.get('/v1/equip_maintain/vo/' + data.maintainId).then(res => res),
  get: id => http.get('/v1/equip_maintain/' + id).then(res => res),
  getTemp: id => http.get('/v1/equip_maintain/getTemp/').then(res => res),
  list: data => http.post('/v1/equip_maintain/list', data).then(res => res),
  edit: data =>
    http.put('/v1/equip_maintain/?id=' + data.id, data.obj).then(res => res),
  add: data => http.post('/v1/equip_maintain/', data).then(res => res),
  approve: data =>
    http.post('/v1/equip_maintain/approve/' + data.id, data).then(res => res),
  addDetail: data =>
    http
      .post('/v1/equip_maintain/addDetail/?equipIds=' + data.equipIds, data.obj)
      .then(res => res)
}
