import http from '../http'

export default {
  page: data => http.post('/v1/equip_purchase/page', data).then(res => res),
  getById: id => http.get('/v1/equip_purchase/vo/' + id).then(res => res),
  getTemp: () => http.get('/v1/equip_purchase/getTemp/').then(res => res),
  edit: data =>
    http.put('/v1/equip_purchase/vo/' + data.id, data.obj).then(res => res),
  add: data => http.post('/v1/equip_purchase/', data).then(res => res),
  deleteByIds: ids =>
    http.post('/v1/equip_purchase/delete/?ids=' + ids).then(res => res),
  // 一级审批(实验室主任)
  approve: data =>
    http
      .post('/v1/equip_purchase/approve_flow/' + data.taskId, data)
      .then(res => res),
  // 二级审批（总经理）
  approveManager: data =>
    http
      .post('/v1/equip_purchase/approve_manager/' + data.id, data)
      .then(res => res)
}
