import http from '../http'

export default {
  page: data =>
    http.post('/v1/frame_inner_check_manage/page', data).then(res => res),
  deleteById: id =>
    http.delete('/v1/frame_inner_check_manage/' + id).then(res => res),
  getById: id =>
    http.get('/v1/frame_inner_check_manage/' + id).then(res => res),
  edit: data =>
    http
      .put('/v1/frame_inner_check_manage/' + data.id, data.obj)
      .then(res => res),
  add: data =>
    http.post('/v1/frame_inner_check_manage/', data).then(res => res),
  submitById: data =>
    http
      .post('/v1/frame_inner_check_manage/submit/?ids=' + data)
      .then(res => res),
  approve: data =>
    http
      .post('/v1/frame_inner_check_manage/approve/' + data.taskId, data)
      .then(res => res)
}
