import http from '../http'

export default {
  page: data => http.post('/v1/month_plan/page', data).then(res => res),
  pagePlan: data =>
    http.post('/v1/month_plan/page_plan', data).then(res => res),
  deleteById: id => http.delete('/v1/month_plan/' + id).then(res => res),
  getById: id => http.get('/v1/month_plan/' + id).then(res => res),
  edit: data =>
    http.put('/v1/month_plan/' + data.id, data.obj).then(res => res),
  add: data => http.post('/v1/month_plan/', data).then(res => res),
  submitById: data =>
    http.post('/v1/month_plan/submit_batch?ids=' + data).then(res => res),
  approve: data =>
    http.post('/v1/month_plan/approve/' + data.taskId, data).then(res => res)
}
