import http from '../http'

export default {
  page: data => http.post('/v1/satisfaction_item/page', data).then(res => res),
  list: data => http.post('/v1/satisfaction_item/list', data).then(res => res),
  deleteById: id => http.delete('/v1/satisfaction_item/' + id).then(res => res),
  getById: id => http.get('/v1/satisfaction_item/' + id).then(res => res),
  edit: data =>
    http.put('/v1/satisfaction_item/' + data.id, data.obj).then(res => res),
  add: data => http.post('/v1/satisfaction_item/', data).then(res => res),
  submitById: data =>
    http
      .post('/v1/satisfaction_item/submit_batch?ids=' + data)
      .then(res => res),
  approve: data =>
    http
      .post('/v1/satisfaction_item/approve/' + data.taskId, data)
      .then(res => res)
}
