/**
 * 系统消息表相关
 */
import http from '../http'

export default {
  page: data =>
    http.post('/message/v1/message_type/page', data).then(res => res),
  list: () => http.post('/message/v1/message_type/my').then(res => res),
  add: data => http.post('/message/v1/message_type/', data).then(res => res),
  edit: data =>
    http.put('/message/v1/message_type/' + data.id, data.obj).then(res => res),
  deleteByIds: ids =>
    http.delete('/message/v1/message_type/?ids=' + ids).then(res => res),
  getById: id => http.get('/message/v1/message_type/' + id).then(res => res),
  getLinkByType: data =>
    http.post('/message/v1/message_type/get_by_msgType', data).then(res => res)
}
