/**
 * 报表导出表
 */

import http from '../http'
import httpJson from '../httpJson'

export default {
  page: data => {
    const pages = data.page === undefined ? 1 : data.page
    const obj = httpJson
      .post('/print/v1/export/page?page=' + pages + '&rows=' + data.rows, data)
      .then(res => res)
    return obj
  },
  add: data => http.post('/print/v1/export/', data).then(res => res),
  edit: data =>
    http.put('/print/v1/export/' + data.id, data.obj).then(res => res),
  deleteById: data => http.delete('/print/v1/export/' + data).then(res => res)
}
