/**
 * 字典相关
 */

import http from '../http'

export default {
  // 根据分类查询
  getItem: data =>
    http.get('/v1/dict/dict_class_item?classType=' + data).then(res => res),
  pageDict: data => http.post('/v1/dict/page', data).then(res => res),
  getById: id => http.get('/v1/dict/' + id).then(res => res),
  deleteById: id => http.delete('/v1/dict/' + id).then(res => res),
  edit: data => http.put('/v1/dict/' + data.id, data.obj).then(res => res),
  add: data => http.post('/v1/dict/', data).then(res => res)
}
