import Vue from 'vue'
import Store from 'store2'
import extend from 'extend'
import dateformat from 'dateformat'
import serialize from 'form-serialize'
import string from 'string'
import FileSaver from 'file-saver'
import XLSX from 'xlsx'
import global from '../api/config'
/**
 * 字符串函数库
 * https://www.npmjs.com/package/string
 */
Vue.prototype.$string = string
/**
 * 日期格式化
 *  https://www.npmjs.com/package/dateformat
 */
Vue.prototype.$dateformat = dateformat
/**
 * 对象扩展
 * https://www.npmjs.com/package/extend
 */
Vue.prototype.$extend = extend
/**
 * 表单序列化
 *  https://www.npmjs.com/package/form-serialize
 */
Vue.prototype.$serialize = function(formId) {
  const form = document.querySelector('#' + formId)

  // 通用方法去除输入框前后空格
  $(document).ready(function() {
    $('form').on('change', function() {
      $('form input[type=text]').each(function() {
        this.value = $.trim(this.value)
      })
    })
  })

  return serialize(form, { hash: true })
}
/**
 *table默认展示多少条数据
 */
Vue.prototype.$pageParams = 50
/**
 *table默认展示切换list
 */
Vue.prototype.$pageSizeOpts = [30, 50, 100, 200, 300, 500]
/**
 *table默认layout
 */
Vue.prototype.$pageLayout = 'total, sizes, prev, pager, next, jumper'
/**
 * 面包屑
 */
Vue.prototype.$showBread = function(route) {
  const breadCrumbList = []
  for (let i = 0; i < route.matched.length; i++) {
    breadCrumbList.push(
      route.matched[i].meta ? route.matched[i].meta.title : ''
    )
  }
  return breadCrumbList
}
/**
 * optColWidth(表格列的宽度)
 * listLength--- 操作列按钮数组
 */
Vue.prototype.$optColWidth = function(list) {
  if (process.browser) {
    const width = 20
    return list.length > 0 ? 87 + width * (list.length - 1) : 0
  }
}
/**
 *
 * 返回当前人登录信息
 */
Vue.prototype.$userInfo = function() {
  if (process.browser) {
    return global.getUserInfo()
  }
}
/**
 * 返回有权限的操作列按钮
 * @param list
 * @returns {Array}
 */
Vue.prototype.$showBtnList = function(list) {
  if (process.browser) {
    const arrayList = []
    if (list) {
      for (let i = 0; i < list.length; i++) {
        if (this.$showBtn(list[i].id)) {
          arrayList.push(list[i])
        }
      }
    }
    return arrayList
  }
}
/**
 * base64转换成图片格式（png）
 *
 */
Vue.prototype.$baseCharCode = function(urlData, type) {
  // 去掉url的头，并转换为byte   // 处理异常,将ascii码小于0的转换为大于0，type 为图片的名称
  const bytes = window.atob(urlData.split(',')[1])
  const ab = new ArrayBuffer(bytes.length)
  const ia = new Uint8Array(ab)
  for (let i = 0; i < bytes.length; i++) {
    ia[i] = bytes.charCodeAt(i)
  }
  return new Blob([ab], { type: type })
}
/**
 * table高度
 */
Vue.prototype.$tableHeight = function(name, cutHeight) {
  // 通过 process.browser 来区分环境
  if (process.browser) {
    let height = ''
    if (name) {
      switch (name) {
        // 有按钮和查询条件
        case 'search':
          height = document.documentElement.clientHeight - 255
          break
        // 有按钮和无查询条件
        case 'noSearch':
          height = document.documentElement.clientHeight - 210
          break
        // 有tab有按钮和有查询条件
        case 'tabSearch':
          height = document.documentElement.clientHeight - 328
          break
        // 有tab有按钮和无查询条件
        case 'tabNoSearch':
          height = document.documentElement.clientHeight - 275
          break
        // 有查询条件没有按钮
        case 'noBtn':
          height = document.documentElement.clientHeight - 240
          break
        // 有查询条件有tab没有按钮
        case 'tabNoBtn':
          height = document.documentElement.clientHeight - 275
          break
        // 有按钮和查询条件（两行查询条件）
        case 'searchTwo':
          height = document.documentElement.clientHeight - 330
          break
        // 无按钮，有查询条件（两行查询条件）
        case 'searchTwoNoBtn':
          height = document.documentElement.clientHeight - 300
          break
        // 有按钮、tab和查询条件（两行查询条件）
        case 'tabSearchTwo':
          height = document.documentElement.clientHeight - 375
          break
        // 弹出框中table高度（自适应屏幕高度）
        case 'tableModal':
          height = document.documentElement.clientHeight - 330
          break
        // table详情高度（自适应屏幕高度）
        case 'tableDetail':
          height = document.documentElement.clientHeight - 200 + 'px'
          break
        // 左侧树高度（自适应屏幕高度）
        case 'ztreeHeight':
          height = document.documentElement.clientHeight - 222 + 'px'
          break
        case 'ruleHeight':
          height = document.documentElement.clientHeight - 360
      }
    } else if (cutHeight !== undefined) {
      height = document.documentElement.clientHeight - cutHeight
    }
    return height
  }
}
/**
 * 按钮权限
 */
Vue.prototype.$showBtn = function(id) {
  if (id === '') {
    // 不添加权限
    return true
  }
  let result = false
  const list = Store.session('showBtnList')
    ? Store.session('showBtnList').split(',')
    : []
  // const list = this.$store.state.btnList
  const l = list.length
  if (l > 0) {
    // 添加权限
    for (let i = 0; i < l; i++) {
      if (list[i] === id) {
        result = true
        break
      }
    }
  }
  return result
}
Vue.prototype.$serializeFormSearch = function(formObj) {
  const newFormObj = {}
  for (const key in formObj) {
    // 不为空的时候传值
    if (formObj[key] !== '') {
      newFormObj[key] = formObj[key]
    }
  }
  return newFormObj
}
/**
 * 注：企业的table列重新分配以后，用户个性化（或自定义的表格列）将清空。☆
 * table columns 用户自定义
 * pageColumns ------ 本地数据
 * userCodeList --- 获取用户的表格数据
 *
 */
Vue.prototype.$tableColumns = function(pageColumns, userCodeList) {
  // 用户table数据
  const userResult = []
  for (let i = 0; i < pageColumns.length; i++) {
    userCodeList.map(item => {
      if (item === pageColumns[i].key) {
        userResult.push(pageColumns[i])
      }
    })
  }
  return userResult
}
/**
 * 验证固话
 */
Vue.prototype.$isPhone = function(value) {
  const isPhone = /^([0-9]{3,4}-)?[0-9]{7,8}$/
  return isPhone.test(value)
}
/**
 * 验证手机号
 */
Vue.prototype.$isMobile = function(value) {
  const myMobile = /^[1][0-9]{10}$/
  return myMobile.test(value)
}
/**
 * table 导出EXCEL（支持选中导出，支持查询导出，支持整个table导出）---
 *
 * id:table的id,
 * title:导出的excel名字,
 * pageColumns:表头列
 * selectData：表格数据（可以是选中的，也可以是全部数据，若要导出全部数据则需执行page方法，page:1,rows:5000,最多导出5000条数据）
 *
 */
Vue.prototype.$exportExcel = function(id, title, pageColumns, selectData) {
  // 正在导出的提示...
  this.$message.loading({
    content: '正在导出，请稍后...',
    duration: 0
  })

  // 创建一个div(原生)
  const parentdiv = document.createElement('div')

  // 自制表头(循环pageColumns)
  const theadTr = document.createElement('tr')
  const tbodyTr = document.createElement('tbody')

  /** ***********************表数据**************************/
  // 只导出选中的数据
  for (let j = 0; j < selectData.length; j++) {
    const tr = document.createElement('tr')
    const selectDataIndex = selectData[j]
    for (let k = 0; k < pageColumns.length; k++) {
      const td = document.createElement('td')
      if (pageColumns[k].date) {
        // 日期格式化 --- yyyy-mm-dd
        td.innerHTML = selectDataIndex[pageColumns[k].key]
          ? this.$dateformat(selectDataIndex[pageColumns[k].key], 'yyyy-mm-dd')
          : ''
      } else if (pageColumns[k].dateTime) {
        // 日期格式化--- yyyy-mm-dd HH:MM:ss
        td.innerHTML = selectDataIndex[pageColumns[k].key]
          ? this.$dateformat(
              selectDataIndex[pageColumns[k].key],
              'yyyy-mm-dd HH:MM:ss'
            )
          : ''
      } else if (pageColumns[k].key === 'status') {
        td.innerHTML =
          selectDataIndex[pageColumns[k].key] === 0
            ? '禁用'
            : selectDataIndex[pageColumns[k].key] === 1
              ? '正常'
              : '待激活'
      } else {
        // 普通文本
        td.innerHTML =
          selectDataIndex[pageColumns[k].key] === undefined
            ? ''
            : selectDataIndex[pageColumns[k].key]
      }

      tr.appendChild(td)
    }
    tbodyTr.appendChild(tr)
  }

  /** ***********************表头信息********************************/

  for (let i = 0; i < pageColumns.length; i++) {
    const th = document.createElement('th')
    th.innerHTML = pageColumns[i].title
    theadTr.appendChild(th)
  }

  /** *************************表头+内容进行拼接**********************************/

  parentdiv.appendChild(theadTr)
  parentdiv.appendChild(tbodyTr)

  /** *************************导出**********************************/

  const wb = XLSX.utils.table_to_book(parentdiv)

  /* get binary string as output */
  const wbout = XLSX.write(wb, {
    bookType: 'xlsx',
    bookSST: true,
    type: 'array'
  })
  try {
    FileSaver.saveAs(
      new Blob([wbout], { type: 'application/octet-stream' }),
      title + '.xlsx'
    )
  } catch (e) {
    if (typeof console !== 'undefined') console.log(e, wbout)
  }

  // 销毁导出提示
  setTimeout(() => {
    this.$message.destroy()
    return wbout
  }, 1500)
}
/**
 * 重置数据
 * */
Vue.prototype.$resetFields = function(formObj) {
  for (const key in formObj) {
    formObj[key] = ''
  }
  return formObj
}
/**
 *搜索条件清空缓存处理方式(form表单 查询)
 *
 */
Vue.prototype.$serializeForm = function(formObj) {
  const newFormObj = {}
  for (const key in formObj) {
    // 不为空的时候传值
    if (formObj[key] !== '') {
      newFormObj[key] = formObj[key]
    }
  }
  return newFormObj
}
/***
 *生成N位随机数
 * */
Vue.prototype.$randomCode = function() {
  let code = ''
  const random = [
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    8,
    9,
    'A',
    'B',
    'C',
    'D',
    'E',
    'F',
    'G',
    'H',
    'I',
    'J',
    'K',
    'L',
    'M',
    'N',
    'O',
    'P',
    'Q',
    'R',
    'S',
    'T',
    'U',
    'V',
    'W',
    'X',
    'Y',
    'Z'
  ]
  // 循环codeLength 设置的n就是循环n次 n:6
  for (let i = 0; i < 4; i++) {
    // 设置随机数范围,这设置为0 ~ 36
    const index = Math.floor(Math.random() * 36)
    // 字符串拼接 将每次随机的字符 进行拼接
    code += random[index]
  }
  return new Date().getTime() + code
}

/**
 * 类别判断（编辑的时候不能选择相同的类别，根据ID判断）
 * {id:'',classifyId:''} // 行id,与类别id
 * */
Vue.prototype.$judgeClassify = function(data) {
  let result = false
  if (data.classifyId) {
    // 上级类别存在的情况
    if (data.id === data.classifyId) {
      result = false // 重复
    } else {
      result = true // 不重复
    }
  } else {
    // 上级类别不存在的情况
    result = true
  }
  return result
}

/**
 *临时存放系统管理的菜单信息，该分支修改完成，统一修改数据库即可
 *
 */
// Vue.prototype.$sysMenus = function() {
//   const result = [
//     {
//       name: '系统管理',
//       leftMenus: [
//         {
//           name: '系统管理',
//           icon: 'pt-config',
//           subMenus: [
//             {
//               name: '菜单权限管理',
//               uri: '/sys/sys_manage/resource',
//               icon: 'pt-config'
//             },
//             {
//               name: '按钮权限管理',
//               uri: '/sys/sys_manage/btn_resource'
//             },
//             {
//               name: '表格权限管理',
//               uri: '/sys/sys_manage/table_col'
//             },
//             {
//               name: '报表设计',
//               uri: '/sys/sys_manage/report_design'
//             },
//             {
//               name: '报表配置',
//               uri: '/sys/sys_manage/report_config'
//             },
//             {
//               name: '表单管理',
//               uri: '/sys/sys_manage/form_manage'
//             },
//             {
//               name: '表单配置',
//               uri: '/sys/sys_manage/form_config'
//             },
//             {
//               name: '操作日志',
//               uri: '/sys/sys_manage/log'
//             },
//             {
//               name: '黑名单管理',
//               uri: '/sys/sys_manage/black_list'
//             },
//             {
//               name: '系统模块管理',
//               uri: '/sys/sys_manage/sys_module'
//             },
//             {
//               name: '平台管理',
//               uri: '/sys/sys_manage/system'
//             },
//             {
//               name: '水印管理',
//               uri: '/sys/sys_manage/watermark'
//             }
//           ],
//           uri: '/'
//         },
//         {
//           name: '系统配置',
//           subMenus: [
//             {
//               name: '企业管理',
//               uri: '/sys/sys_config/company'
//             },
//             {
//               name: '组织管理',
//               uri: '/sys/sys_config/org'
//             },
//             {
//               name: '角色管理',
//               uri: '/sys/sys_config/role'
//             },
//             {
//               name: '用户管理',
//               uri: '/sys/sys_config/user'
//             },
//             {
//               name: '模版管理',
//               uri: '/sys/sys_config/print_template'
//             },
//             {
//               name: '编号管理',
//               uri: '/sys/sys_config/code_rule'
//             },
//             {
//               name: '模块管理',
//               uri: '/sys/sys_config/print_module'
//             }
//           ],
//           uri: '/'
//         },
//         {
//           name: '工作流管理',
//           subMenus: [
//             {
//               name: '我的任务',
//               uri: '/sys/workflow/flow_task'
//             },
//             {
//               name: '工作组管理',
//               uri: '/sys/workflow/flow_group'
//             },
//             {
//               name: '流程部署列表',
//               uri: '/sys/workflow/flow_process'
//             }
//           ],
//           uri: '/workflow'
//         },
//         {
//           name: '个人资料',
//           subMenus: [
//             {
//               name: '修改密码',
//               uri: '/sys/personal_data/password_edit'
//             },
//             {
//               name: '我的首页',
//               uri: '/sys/personal_data/my_home'
//             },
//             {
//               name: '基本资料',
//               uri: '/sys/personal_data/base_info'
//             },
//             {
//               name: '微信绑定',
//               uri: '/sys/personal_data/wechat'
//             }
//           ],
//           uri: '/'
//         },
//         {
//           name: '基础管理',
//           subMenus: [
//             {
//               name: '国家管理',
//               uri: '/sys/base_manage/country'
//             },
//             {
//               name: '省份管理',
//               uri: '/sys/base_manage/province'
//             },
//             {
//               name: '城市管理',
//               uri: '/sys/base_manage/city'
//             },
//             {
//               name: '地区管理',
//               uri: '/sys/base_manage/area'
//             }
//           ],
//           uri: '/'
//         },
//         {
//           name: '消息管理',
//           subMenus: [
//             {
//               name: '消息管理',
//               uri: '/sys/message_manage/message'
//             },
//             {
//               name: '消息类型配置',
//               uri: '/sys/message_manage/message_type'
//             },
//             {
//               name: '我的消息',
//               uri: '/sys/message_manage/my_message'
//             }
//           ],
//           uri: '/'
//         }
//       ],
//       code: 'sys',
//       uri: 'http://web.dev.patzn.com:8085'
//     }
//   ]
//   return result
// }
