/**
 * 系统管理地址路由
 */
import LmsBaseDict from '../pages/res/dict/LmsBaseDict'
import UserGroup from '../pages/res/user-group/UserGroup'
import Customer from '../pages/res/customer/Customer'
import Supplier from '../pages/res/supplier/Supplier'
import SupplierType from '../pages/res/supplier-type/SupplierType'
import ServiceType from '../pages/res/service-type/ServiceType'
import codeRule from '../pages/sys-config/code-rule/codeRule'
import FileManage from '../pages/file/fileManager'
import LmsTemplateType from '../pages/template-type/LmsTemplateType'
import LmsTemplate from '../pages/template/LmsTemplate'
import LmsCarInfo from '../pages/res/car/LmsCarInfo'
import LmsEnvMicrobeMonitor from '../pages/lms-env/lms-env-microbe-monitor/LmsEnvMicrobeMonitor'
import LmsEnvNormalMonitor from '../pages/lms-env/lms-env-normal-monitor/LmsEnvNormalMonitor'

export default [
  {
    path: 'dict',
    component: LmsBaseDict,
    meta: { title: '字典管理' }
  },
  {
    path: 'user_group',
    component: UserGroup,
    meta: { title: '用户编组' }
  },
  {
    path: 'customer',
    component: Customer,
    meta: { title: '客户管理' }
  },
  {
    path: 'supplier',
    component: Supplier,
    meta: { title: '供应商管理' }
  },
  {
    path: 'supplier_type',
    component: SupplierType,
    meta: { title: '供应商分类' }
  },
  {
    path: 'service_type',
    component: ServiceType,
    meta: { title: '服务类型' }
  },
  {
    path: 'code_rule',
    component: codeRule,
    meta: { title: '编码规则' }
  },
  {
    path: 'file_manage',
    component: FileManage,
    meta: { title: '文件管理' }
  },
  {
    path: 'template_type',
    component: LmsTemplateType,
    meta: { title: '模板类别管理' }
  },
  {
    path: 'template',
    component: LmsTemplate,
    meta: { title: '模板管理' }
  },
  {
    path: 'car_manage',
    component: LmsCarInfo,
    meta: { title: '车辆管理' }
  },
  {
    path: 'microbe_env',
    component: LmsEnvMicrobeMonitor,
    meta: { title: '微生物环境检测' }
  },
  {
    path: 'routine_env',
    component: LmsEnvNormalMonitor,
    meta: { title: '常规生物检测' }
  }
]
