/**
 * 地址路由
 */
import index from '../pages/index'
import login from '../pages/login'
import blank from '../pages/blank'
import flowform from '../pages/Flowform'
import lock from '../pages/lock.vue' // 锁屏
import sysRouters from '../router/sys-routes'
import resRouters from '../router/res-routes'
import aptitudeRouters from '../router/aptitude-routes'
import drugRouters from '../router/drug-routes'
import envRouters from '../router/env-routes'
import flowFormRoutes from './flowform-routes'
export default [
  { path: '/lock', name: 'Lock', component: lock, meta: { allowBack: false } },
  {
    path: '/login',
    component: login,
    meta: { allowBack: false }
  },
  {
    path: '/',
    component: index,
    children: [{ path: '/', meta: { title: '首页' } }]
  },
  {
    path: '/sys',
    component: blank,
    children: sysRouters,
    meta: { title: '系统管理' }
  },
  {
    path: '/res',
    component: blank,
    children: resRouters,
    meta: { title: '资源管理' }
  },
  {
    path: '/aptitude',
    component: blank,
    children: aptitudeRouters,
    meta: { title: '资质管理' }
  },
  {
    path: '/drug',
    component: blank,
    children: drugRouters,
    meta: { title: '食药lims管理' }
  },
  {
    path: '/env',
    component: blank,
    children: envRouters,
    meta: { title: '环境监测' }
  },
  { path: '*', redirect: '/' },
  // 工作流表单
  { path: '/flowform', component: flowform, children: flowFormRoutes }
]
