import http from '../http'

export default {
  page: data =>
    http.post('/v1/chemical_rel_delivery/page', data).then(res => res),
  pageTemp: data =>
    http.post('/v1/chemical_rel_delivery/page_temp', data).then(res => res),

  pageByOrderId: data =>
    http.post('/v1/chemical_rel_delivery/page_order_id', data).then(res => res),

  pageApprove: data =>
    http
      .post('/v1/chemical_rel_delivery/page_approve_order_id', data)
      .then(res => res),
  getById: id => http.get('/v1/chemical_rel_delivery/' + id).then(res => res),
  edit: data =>
    http
      .put('/v1/chemical_rel_delivery?id=' + data.id, data.obj)
      .then(res => res),
  add: data => http.post('/v1/chemical_rel_delivery/', data).then(res => res),
  fastOut: data =>
    http
      .post('/v1/chemical_rel_delivery/out_all_stock_' + data.orderId, data)
      .then(res => res),
  editQuantity: data =>
    http
      .put(
        '/v1/chemical_rel_delivery/wait_approval_' +
          data.id +
          '?quantity=' +
          data.quantity
      )
      .then(res => res)
}
