import http from '../http'

export default {
  page: data => http.post('/v1/chemical_userecord/page', data).then(res => res),
  pageByChemicalId: data =>
    http
      .post('/v1/chemical_userecord/page_' + data.chemicalId, data)
      .then(res => res),
  getById: id => http.get('/v1/chemical_userecord/' + id).then(res => res),
  edit: data =>
    http.put('/v1/chemical_userecord?id=' + data.id, data.obj).then(res => res),
  add: data => http.post('/v1/chemical_userecord/', data).then(res => res)
}
