/**
 * 环境合同相关
 */
import http from '../http'

export default {
  getById: id => http.get('/env/v1/sales/' + id).then(res => res),
  // 编辑合同信息
  edit: data => http.put('/env/v1/sales/' + data.id, data.obj).then(res => res),
  // 获取评审单信息
  getReviewInfo: id =>
    http.post('/env/v1/sales/get_review_info?id=' + id).then(res => res),
  // 一级审批
  firstCheckApprove: data =>
    http.post('/env/v1/sales/first_check_approve', data).then(res => res),
  // 二级审批
  secondCheckApprove: data =>
    http.post('/env/v1/sales/second_check_approve', data).then(res => res),
  // 三级审批
  thirdCheckApprove: data =>
    http.post('/env/v1/sales/third_check_approve', data).then(res => res),
  // 合同多级审批的一级审批
  firstMoreCheckApprove: data =>
    http.post('/env/v1/sales/first_more_check_approve', data).then(res => res),
  // 合同多级审批的二级审批
  secondMoreCheckApprove: data =>
    http.post('/env/v1/sales/second_more_check_approve', data).then(res => res)
}
