import http from '../http'

export default {
  page: data => http.post('/v1/env_monitor_record/page', data).then(res => res),
  deleteById: id =>
    http.delete('/v1/env_monitor_record/' + id).then(res => res),
  pageCatalogueItem: data =>
    http
      .post('/v1/env_monitor_record/page-catalogue-item', data)
      .then(res => res),
  pageForCatalogue: data =>
    http
      .post('/v1/env_monitor_record/page-for-catalogue', data)
      .then(res => res),
  getById: id => http.get('/v1/env_monitor_record/' + id).then(res => res),
  edit: data =>
    http.put('/v1/env_monitor_record?id=' + data.id, data.obj).then(res => res),
  add: data => http.post('/v1/env_monitor_record/', data).then(res => res)
}
