import http from '../http'
import { https } from '../https'
export default {
  page: data =>
    http.post('/v1/equip_maintain_manage/page', data).then(res => res),
  getById: id =>
    http.get('/v1/equip_maintain_manage/vo/' + id).then(res => res),
  get: id => http.get('/v1/equip_maintain_manage/' + id).then(res => res),
  getTemp: id =>
    http.get('/v1/equip_maintain_manage/getTemp/').then(res => res),
  list: data =>
    http.post('/v1/equip_maintain_manage/list', data).then(res => res),
  edit: data =>
    http
      .put('/v1/equip_maintain_manage/?id=' + data.id, data.obj)
      .then(res => res),
  add: data => http.post('/v1/equip_maintain_manage/', data).then(res => res),
  approve: data =>
    http
      .post('/v1/equip_maintain_manage/approve/' + data.id, data)
      .then(res => res),
  addDetail: data =>
    http
      .post(
        '/v1/equip_maintain_manage/addDetail/?equipIds=' + data.equipIds,
        data.obj
      )
      .then(res => res),
  addDo: data =>
    https
      .post('/v1/equip_maintain_manage/add/', JSON.stringify(data))
      .then(res => res)
}
