import http from '../http'
export default {
  pageRepair: data =>
    http.post('/v1/equip_repair/page_vo', data).then(res => res),
  getById: id => http.get('/v1/equip_repair/vo/' + id).then(res => res),
  pageManage: data =>
    http.post('/v1/equip_repair/page_manage', data).then(res => res),
  get: id => http.get('/v1/equip_repair/' + id).then(res => res),
  getTemp: id => http.get('/v1/equip_repair/getTemp/').then(res => res),
  list: data => http.post('/v1/equip_repair/list', data).then(res => res),
  edit: data =>
    http.put('/v1/equip_repair/?id=' + data.id, data.obj).then(res => res),
  add: data => http.post('/v1/equip_repair/', data).then(res => res),
  approve: data =>
    http.post('/v1/equip_repair/approve/' + data.id, data).then(res => res),
  addDetail: data =>
    http
      .post('/v1/equip_repair/addDetail/?equipIds=' + data.equipIds, data.obj)
      .then(res => res)
}
