/**
 * 系统消息表相关
 */
import http from '../http'

export default {
  page: data => http.post('/v1/message/page', data).then(res => res),
  list: () => http.post('/v1/message/my').then(res => res),
  add: data => http.post('/v1/message/', data).then(res => res),
  edit: data =>
    http.put('/message/v1/message/' + data.id, data.obj).then(res => res),
  deleteByIds: ids =>
    http.delete('/message/v1/message/?ids=' + ids).then(res => res),
  // 一键删除
  deleteAll: () => http.delete('/message/v1/message/all').then(res => res),
  getById: id => http.get('/message/v1/message/' + id).then(res => res),
  send: data =>
    http
      .post('/message/v1/message/send_' + data.id + '?userIds=' + data.userIds)
      .then(res => res),
  myPage: data => http.post('/v1/message/page_my', data).then(res => res),
  read: ids =>
    http.post('/message/v1/message/read?relIds=' + ids).then(res => res),
  // 一键标记为已读
  readAll: () => http.post('/message/v1/message/read_all').then(res => res)
}
