/**
 * 组件相关
 */
import http from '../http'
import httpJson from '../httpJson'

export default {
  // 标准版委托保存
  saveContract: data =>
    httpJson
      .post(
        '/res/v1/component_flow/save_configure_flow?companyId=' +
          data.companyId,
        data.dto
      )
      .then(res => res),
  saveFoodFlow: data =>
    httpJson
      .post(
        '/res/v1/component_flow/save_configure_flow/' +
          data.type +
          '?companyId=' +
          data.companyId,
        data.dto
      )
      .then(res => res),
  saveSimpleContract: data =>
    httpJson
      .post(
        '/res/v1/component_flow/save_configure_flow_simple?companyId=' +
          data.companyId,
        data.dto
      )
      .then(res => res),
  saveItem: data =>
    httpJson
      .post(
        '/res/v1/component_flow/save_item_configure_flow?companyId=' +
          data.companyId,
        data.dto
      )
      .then(res => res),
  flowOption: data =>
    http
      .post('/res/v1/component_flow/env_contract_flow_option', data)
      .then(res => res),
  flowResult: data =>
    http
      .post('/res/v1/component_flow/env_contract_flow_result', data)
      .then(res => res),
  allStatus: data =>
    http.post('/res/v1/component_flow/all_status', data).then(res => res)
}
