import http from '../http'

export default {
  page: data => http.post('/v1/staff_train_record/page', data).then(res => res),
  getTemp: data =>
    http.post('/v1/staff_train_record/temp', data).then(res => res),
  getById: id => http.get('/v1/staff_train_record/' + id).then(res => res),
  getVOById: id => http.get('/v1/staff_train_record/vo/' + id).then(res => res),
  deleteById: id =>
    http.delete('/v1/staff_train_record/' + id).then(res => res),
  list: data => http.post('/v1/staff_train_record/list', data).then(res => res),
  edit: data =>
    http.put('/v1/staff_train_record/' + data.id, data.obj).then(res => res),
  add: data => http.post('/v1/staff_train_record/', data).then(res => res),
  commit: data =>
    http.post('/v1/staff_train_record/commit', data).then(res => res),
  approve: data =>
    http
      .post('/v1/staff_train_record/approve/' + data.taskId, data)
      .then(res => res),
  submitById: data =>
    http.post('/v1/staff_train_record/commit/?id=' + data).then(res => res),
  enTrue: data =>
    http.post('/v1/staff_train_record/entrue', data).then(res => res)
}
