/**
 * 地区相关
 */
import http from '../http'

export default {
  page: data => http.post('/v1/file_template/page', data).then(res => res),
  deleteById: id => http.delete('/v1/file_template/' + id).then(res => res),
  getTree: data =>
    http.put('/v1/file_template_classify/get_tree', data).then(res => res),
  list: data => http.post('/v1/area/list', data).then(res => res),
  add: data => http.post('/v1/file_template_classify/', data).then(res => res),
  edit: data =>
    http
      .put('/v1/file_template_classify/' + data.id, data.obj)
      .then(res => res),
  getById: id => http.get('/v1/file_template_classify/' + id).then(res => res),
  getArea: data => http.post('/v1/area/list_' + data).then(res => res)
}
