import http from '../http'

export default {
  pageSampleType: data =>
    http.post('/v1/test_type/page', data).then(res => res),
  pagePointType: data =>
    http.post('/v1/test_type/page_point', data).then(res => res),
  getById: id => http.get('/v1/test_type/' + id).then(res => res),
  edit: data =>
    http.put('/v1/test_type?id=' + data.id, data.obj).then(res => res),
  add: data => http.post('/v1/test_type/', data).then(res => res),
  addPoint: data => http.post('/v1/test_type/add-point', data).then(res => res),
  getStandardList: data =>
    http.post('/v1/test_type/list-string', data).then(res => res),
  deleteById: id => http.delete('/v1/test_type/' + id).then(res => res),
  categoryClassTree: data =>
    http.post('/v1/test_type/list-class', data).then(res => res),
  pointClassTree: data =>
    http.post('/v1/test_type/list-point-class', data).then(res => res)
}
