import http from '../http'

export default {
  page: data => http.post('/v1/chemical_category/page', data).then(res => res),
  getTree: data =>
    http.put('/v1/chemical_category/get_tree', data).then(res => res),

  getTreeListAll: data =>
    http.get('/v1/chemical_category/category_tree_all', data).then(res => res),
  excludeRoleList: data =>
    http
      .post('/v1/chemical_category/list_include_role/' + data)
      .then(res => res),
  getById: id => http.get('/v1/chemical_category/' + id).then(res => res),
  edit: data =>
    http.put('/v1/chemical_category?id=' + data.id, data.obj).then(res => res),
  add: data => http.post('/v1/chemical_category/', data).then(res => res),
  addRoleCategory: data =>
    http
      .post(
        '/v1/chemical_category/role_category/' +
          data.id +
          '?categoryIds=' +
          data.idsList
      )
      .then(res => res)
}
