import http from '../http'

export default {
  page: data => http.post('/v1/chemical/page', data).then(res => res),
  pageVO: data => http.post('/v1/chemical/page_vo', data).then(res => res),
  pageIncludeClassify: data =>
    http
      .post('/v1/chemical/page_include_classify/' + data.classifyId, data)
      .then(res => res),

  pageExcludeClassify: data =>
    http
      .post('/v1/chemical/page_exclude_classify/' + data.classifyId, data)
      .then(res => res),

  getTree: data => http.put('/v1/chemical/get_tree', data).then(res => res),
  getById: id => http.get('/v1/chemical/' + id).then(res => res),
  edit: data =>
    http.put('/v1/chemical?id=' + data.id, data.obj).then(res => res),
  add: data => http.post('/v1/chemical/', data).then(res => res)
}
