import http from '../http'

export default {
  page: data =>
    http.post('/v1/chemical_rel_purchase/page', data).then(res => res),
  pagePurchaseOrder: data =>
    http
      .post('/v1/chemical_purchase_order/page-purchase-order', data)
      .then(res => res),
  pageWaitPurchase: data =>
    http
      .post('/v1/chemical_purchase_order/page-wait-purchase', data)
      .then(res => res),
  getTree: data =>
    http.put('/v1/chemical_rel_purchase/get_tree', data).then(res => res),
  getById: id => http.get('/v1/chemical_purchase_order/' + id).then(res => res),
  edit: data =>
    http
      .put('/v1/chemical_rel_purchase?id=' + data.id, data.obj)
      .then(res => res),
  add: data => http.post('/v1/chemical_rel_purchase/', data).then(res => res),
  submitOrderFlow: data =>
    http
      .post('/v1/chemical_purchase_order/flow_submit?ids=' + data.id, data)
      .then(res => res),
  approve: data =>
    http
      .post('/v1/chemical_purchase_order/approve/' + data.taskId, data)
      .then(res => res),
  addConsumeRelPurchase: data =>
    http
      .post('/v1/chemical_rel_purchase/?chemicalIds=' + data)
      .then(res => res),
  // 采购单
  savePurOrder: data =>
    http.post('/v1/chemical_purchase_order/save_order', data).then(res => res)
}
