import axios from 'axios'
import global from './config'
const downfile = async function(url, method) {
  const result = await axios({
    url: `${global.baseURL}${url}`,
    method: method || 'post',
    headers: {
      accessToken: localStorage.getItem('accessToken')
    },
    responseType: 'blob'
  })
  return result
}

const downBlob = function(content, filename) {
  const blob = new Blob([content])
  const url = window.URL.createObjectURL(blob)
  console.log(url)
  const dom = document.createElement('a')
  dom.style.display = 'none'
  dom.href = url
  dom.target = '_blank'
  dom.setAttribute('download', filename)
  document.body.appendChild(dom)
  dom.click()
  dom.remove()
}

export const getDown = async function(url, filename, method) {
  const result = await downfile(url, method)
  console.log(result)
  if (result) {
    downBlob(result.data, filename)
  }
}
