import http from '../http'

export default {
  pageCatalogueItem: data =>
    http.post('/v1/catalogue_item/page-catalogue-item', data).then(res => res),
  getById: id => http.get('/v1/catalogue_item/' + id).then(res => res),
  deleteById: id => http.delete('/v1/catalogue_item/' + id).then(res => res),
  edit: data =>
    http.put('/v1/catalogue_item?id=' + data.id, data.obj).then(res => res),
  add: data => http.post('/v1/catalogue_item/', data).then(res => res),
  saveCatalogueItem: data =>
    http
      .post(
        '/v1/catalogue_item/save-catalogue-item?aptitudeIds=' +
          data.aptitudeIds +
          '&catalogueId=' +
          data.catalogueId
      )
      .then(res => res)
}
