/**
 * 检测类型管理
 */

import http from '../http'

export default {
  // page 记得要修改 todo
  pageSampleAnnex: data =>
    http.post('/v1/sample_annex/page', data).then(res => res),
  // 添加
  add: data => http.post('/llgt/v1/category/', data).then(res => res),
  // 编辑
  edit: data =>
    http.put('/llgt/v1/category/' + data.id, data.obj).then(res => res),
  // 详情
  getById: id => http.get('/llgt/v1/category/' + id).then(res => res),
  // 删除
  deleteById: ids =>
    http.delete('/llgt/v1/sample_attachment/?ids=' + ids).then(res => res),
  // 类型tree
  categoryTree: data =>
    http.post('/llgt/v1/category/list', data).then(res => res)
}
